/*
 * Decompiled with CFR 0.152.
 */
package com.sync.helpviewer;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.UIManager;
import com.sync.helpviewer.HelpButton;
import com.sync.syncman.dll.SMUtils;
import com.sync.syncman.pm.ProcMgr;
import com.sync.syncman.pm.SMEvent;
import com.sync.syncman.pm.SMListener;
import com.sync.syncman.pm.ShowHelpPageEvent;
import com.sync.syncman.pm.ShowHelpPageListener;
import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;

public class HelpViewer
extends JFrame {
    private String appName;
    private HelpButton backBtn;
    private HelpButton fwdBtn;
    private HelpButton homeBtn;
    private HelpButton printBtn;
    private HelpButton exitBtn;
    private Browser browser;
    private JLabel curURLLabel;
    private String curDocTitle;
    private JPanel btnPanel;

    private HelpViewer(String startURL) {
        super("Help Viewer");
        try {
            UIManager.setLookAndFeel((String)UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Unsupported LookAndFeel");
        }
        this.getContentPane().setLayout(new BorderLayout(1, 1));
        this.btnPanel = new JPanel((LayoutManager)new FlowLayout(0, 16, 2));
        this.btnPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.backBtn = new HelpButton("Back", "Go to previous page");
        this.fwdBtn = new HelpButton("Forward", "Go to next page");
        this.homeBtn = new HelpButton("Home", "Go to master contents page");
        this.printBtn = new HelpButton("Print", "Print this page");
        this.exitBtn = new HelpButton("Close", "Exit the help viewer");
        this.btnPanel.add((Component)((Object)this.backBtn));
        this.btnPanel.add((Component)((Object)this.fwdBtn));
        this.btnPanel.add((Component)((Object)this.homeBtn));
        this.btnPanel.add((Component)((Object)this.printBtn));
        this.btnPanel.add((Component)((Object)this.exitBtn));
        this.getContentPane().add("North", (Component)this.btnPanel);
        this.browser = new Browser();
        this.getContentPane().add("Center", (Component)this.browser);
        this.curURLLabel = new JLabel();
        this.curURLLabel.setFont(new Font("Courier", 0, 11));
        this.curURLLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add("South", (Component)this.curURLLabel);
        ((Window)((Object)this)).addWindowListener(new 1());
        this.browser.addPropertyChangeListener((PropertyChangeListener)new 2());
        ProcMgr.addSMListener((SMListener)new 3());
        try {
            ProcMgr.addHelpPageListener((ShowHelpPageListener)new 4());
        }
        catch (TooManyListenersException e) {
            System.err.println("Too many HelpPageListners");
        }
        this.backBtn.addActionListener(new 5());
        this.fwdBtn.addActionListener(new 6());
        this.homeBtn.addActionListener(new 7());
        this.printBtn.addActionListener(new 8());
        this.exitBtn.addActionListener(new 9());
        this.browser.gotoLocation(startURL);
        ProcMgr.clientRegister((int)37, (String)"", (int)-1, (int)-1);
    }

    private void updateUI() {
        ((Frame)((Object)this)).setTitle(String.valueOf("Help Viewer - ").concat(String.valueOf(this.browser.getDocumentTitle())));
        this.curURLLabel.setText(this.browser.getCurrentLocation());
    }

    private void exit() {
        ProcMgr.clientEnd();
        System.exit(0);
    }

    public static void main(String[] args) {
        String startURL = args.length > 0 ? args[0] : SMUtils.smGetProfileString((String)"HelpViewer", (String)"HomePage", (String)"");
        HelpViewer frame = new HelpViewer(startURL);
        ((Component)((Object)frame)).setSize(630, 470);
        ((Component)((Object)frame)).setVisible(true);
    }

    final /* synthetic */ void access$071() {
        this.exit();
    }

    final /* synthetic */ void access$171() {
        this.updateUI();
    }

    final /* synthetic */ Browser access$271() {
        return this.browser;
    }

    class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HelpViewer.this.access$071();
        }

        9() {
        }
    }

    class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }

        8() {
        }
    }

    class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HelpViewer.this.access$271().gotoLocation(SMUtils.smGetProfileString((String)"HelpViewer", (String)"HomePage", (String)""));
        }

        7() {
        }
    }

    class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HelpViewer.this.access$271().goForward();
            HelpViewer.this.access$171();
        }

        6() {
        }
    }

    class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HelpViewer.this.access$271().goBack();
            HelpViewer.this.access$171();
        }

        5() {
        }
    }

    class 4
    implements ShowHelpPageListener {
        public void showHelpPage(ShowHelpPageEvent e) {
            ((Component)((Object)HelpViewer.this)).setVisible(true);
            if (e.getURL().length() > 0) {
                HelpViewer.this.access$271().gotoLocation(e.getURL());
            } else {
                HelpViewer.this.access$271().gotoLocation(SMUtils.smGetProfileString((String)"HelpViewer", (String)"HomePage", (String)""));
            }
            HelpViewer.this.access$171();
        }

        4() {
        }
    }

    class 3
    implements SMListener {
        public void pmActivate(SMEvent e) {
            ((Component)((Object)HelpViewer.this)).setVisible(true);
        }

        public void closeNow(SMEvent e) {
            HelpViewer.this.access$071();
        }

        3() {
        }
    }

    class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            HelpViewer.this.access$171();
        }

        2() {
        }
    }

    class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            HelpViewer.this.access$071();
        }

        1() {
        }
    }
}

